// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


package com.vasco.orchestration.sample.utils;

import android.app.Activity;
import android.app.Dialog;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;

import com.vasco.orchestration.client.authentication.UserAuthenticationInputCallback;
import com.vasco.orchestration.client.exceptions.AuthenticationInputException;
import com.vasco.orchestration.sample.R;

import java.util.Objects;

public class PresenceAuthenticationDialogFragment extends DialogFragment {
    private final UserAuthenticationInputCallback inputCallback;
    private final Activity activity;

    public PresenceAuthenticationDialogFragment(Activity activity, UserAuthenticationInputCallback inputCallback) {
        this.inputCallback = inputCallback;
        this.activity = activity;
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        builder.setMessage(R.string.presence_authentication)
                .setPositiveButton(R.string.ok, (dialog, id) -> {
                    try {
                        inputCallback.onUserAuthenticationSuccess();
                    } catch (AuthenticationInputException e) {
                        Toast.makeText(activity, e.getMessage(), Toast.LENGTH_SHORT).show();
                        Log.e(activity.getClass().getName(), Objects.requireNonNull(e.getMessage()));
                        inputCallback.onUserAuthenticationAborted();
                    }
                })
                .setNegativeButton(R.string.cancel, (dialog, id) ->
                        inputCallback.onUserAuthenticationAborted());
        return builder.create();
    }
}
